implementation module menudefaccess


//	Clean Object I/O library, version 1.1

import StdMisc, StdTuple
import StdMenuDef, commondef


menuDefGetMenuId :: !(Menu m .ls .ps) -> (!Maybe Id, !Menu m .ls .ps)
menuDefGetMenuId menu=:(Menu _ _ atts)
	# (hasIdAtt,idAtt)	= Select ismenuid undef atts
	| not hasIdAtt
		= (Nothing,menu)
		= (Just (getmenuid idAtt), menu)

menuDefGetSelectState :: !(Menu m .ls .ps) -> (!SelectState, !Menu m .ls .ps)
menuDefGetSelectState menu=:(Menu _ _ atts)
	= (getmenuselectstate (snd (Select ismenuselectstate (MenuSelectState Able) atts)), menu)

menuDefSetAbility :: !(Menu m .ls .ps) !SelectState -> Menu m .ls .ps
menuDefSetAbility (Menu name items atts) able
	= Menu name items (setselectstate able atts)
where
	setselectstate :: !SelectState ![MenuAttribute .ps] -> [MenuAttribute .ps]
	setselectstate select atts
		| found
		= atts1
		= [att:atts1]
	where
		att				= MenuSelectState select
		(found,atts1)	= Replace ismenuselectstate att atts

menuDefGetTitle :: !(Menu m .ls .ps) -> (!Title, !Menu m .ls .ps)
menuDefGetTitle menu=:(Menu name _ _) = (name, menu)

menuDefGetElements :: !(Menu m .ls .ps) -> m .ls .ps
menuDefGetElements (Menu _ items _) = items

menuDefSetElements :: !(Menu m .ls .ps) !(m .ls .ps) -> Menu m .ls .ps
menuDefSetElements (Menu name _ atts) items = Menu name items atts

menuDefGetIndex :: !(Menu m .ls .ps) -> (!Maybe Index,!Menu m .ls .ps)
menuDefGetIndex menu=:(Menu _ _ atts)
	# (hasIndexAtt,indexAtt)	= Select ismenuindex undef atts
	| not hasIndexAtt
		= (Nothing,menu)
		= (Just (getmenuindex indexAtt),menu)


ismenuid			:: !(MenuAttribute .ps)	-> Bool
ismenuid			(MenuId _)				= True
ismenuid			_						= False

ismenuselectstate	:: !(MenuAttribute .ps)	-> Bool
ismenuselectstate	(MenuSelectState _)		= True
ismenuselectstate	_						= False

ismenuindex			:: !(MenuAttribute .ps)	-> Bool
ismenuindex			(MenuIndex _)			= True
ismenuindex			_						= False

ismenushortkey		:: !(MenuAttribute .ps)	-> Bool
ismenushortkey		(MenuShortKey _)		= True
ismenushortkey		_						= False

ismenufunction		:: !(MenuAttribute .ps) -> Bool
ismenufunction		(MenuFunction _)		= True
ismenufunction		_						= False

ismenumodsfunction	:: !(MenuAttribute .ps)	-> Bool
ismenumodsfunction	(MenuModsFunction _)	= True
ismenumodsfunction	_						= False

ismenumarkstate		:: !(MenuAttribute .ps)	-> Bool
ismenumarkstate		(MenuMarkState _)		= True
ismenumarkstate		_						= False

getmenuid :: !(MenuAttribute .ps) -> Id
getmenuid (MenuId id) = id

getmenuselectstate :: !(MenuAttribute .ps) -> SelectState
getmenuselectstate (MenuSelectState select) = select

getmenuindex :: !(MenuAttribute .ps) -> Index
getmenuindex (MenuIndex index) = index

getmenushortkey :: !(MenuAttribute .ps) -> Char
getmenushortkey (MenuShortKey key) = key

getmenufunction :: !(MenuAttribute .ps) -> IOFunction .ps
getmenufunction (MenuFunction f) = f

getmenumodsfunction :: !(MenuAttribute .ps) -> ModsIOFunction .ps
getmenumodsfunction (MenuModsFunction f) = f

getmenumarkstate :: !(MenuAttribute .ps) -> MarkState
getmenumarkstate (MenuMarkState mark) = mark
